<?php

declare(strict_types=1);

namespace Dotclear\Plugin\alias;

use Dotclear\Helper\Process\TraitProcess;

/**
 * @brief       alias install class.
 * @ingroup     alias
 *
 * @author      Olivier Meunier (author)
 * @author      Jean-Christian Denis (latest)
 * @copyright   GPL-2.0 https://www.gnu.org/licenses/gpl-2.0.html
 */
class Install
{
    use TraitProcess;

    public static function init(): bool
    {
        return self::status(My::checkContext(My::INSTALL));
    }

    public static function process(): bool
    {
        if (!self::status()) {
            return false;
        }

        return Alias::createTable();
    }
}
