<?php

declare(strict_types=1);

namespace Dotclear\Plugin\ReadingTracking;

use Dotclear\App;
use Dotclear\Helper\Process\TraitProcess;

/**
 * @brief       ReadingTracking module backend process.
 * @ingroup     ReadingTracking
 *
 * @author      Jean-Christian Paul Denis
 * @copyright   AGPL-3.0
 */
class Backend
{
    use TraitProcess;

    public static function init(): bool
    {
        return self::status(My::checkContext(My::BACKEND));
    }

    public static function process(): bool
    {
        if (!self::status()) {
            return false;
        }

        App::behavior()->addBehaviors([
            'adminAfterUserCreate'          => BackendBehaviors::updateUser(...),
            'adminAfterUserUpdate'          => BackendBehaviors::updateUser(...),
            'adminBeforeUserOptionsUpdate'  => BackendBehaviors::updateUser(...),
            'adminPreferencesFormV2'        => BackendBehaviors::preferencesForm(...),
            'adminUserForm'                 => BackendBehaviors::userForm(...),
            'adminBlogPreferencesFormV2'    => BackendBehaviors::adminBlogPreferencesFormV2(...),
            'adminBeforeBlogSettingsUpdate' => BackendBehaviors::adminBeforeBlogSettingsUpdate(...),
        ]);

        return true;
    }
}
