'use strict';
/*
@licstart  The following is the entire license notice for the
JavaScript code in this page.

Copyright (C) 2018  Access42

The JavaScript code in this page is free software: you can
redistribute it and/or modify it under the terms of the GNU
General Public License (GNU GPL) as published by the Free Software
Foundation, either version 3 of the License, or (at your option)
any later version.  The code is distributed WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU GPL for more details.

As additional permission under GNU GPL version 3 section 7, you
may distribute non-source (e.g., minimized or compacted) forms of
that code without the copy of the GNU GPL normally required by
section 4, provided you include this license notice and a URL
through which recipients can access the Corresponding Source.


@licend  The above is the entire license notice
for the JavaScript code in this page.
*/
/*** AccessConfig **/

const AccessConfig = (() => {
  /*** Configuration **/
  const config = {
    Setup: {
      //id to catch in the html
      id: 'accessconfig',
    },

    /**
    General Setting
    useExtendContrast : true for three choices (default, inverted, enforced), false for two choices (default, inverted)
    **/

    Setting: {
      useExtendContrast: true,
    },
    BodyActive: {
      classSetting: 'active',
    },
    Overlay: {
      classSetting: 'overlay',
    },

    /**
    Modal button and window container
    **/

    ModalButton: {
      id: 'button',
    },
    ModalContainer: {
      classSetting: 'modal',
      titleLang: {
        en: 'Accessibility setting',
        fr: 'Paramètres d’accessibilité',
      },
      titleId: 'title',
      titleClass: 'title',
    },
    CloseButton: {
      id: 'close',
      classSetting: 'close',
      lang: {
        en: 'close',
        fr: 'fermer',
      },
      hiddenTextClass: 'sr-only',
    },

    /**
    Inline content container
    **/

    InlineContentContainer: {
      id: 'inline-c',
    },

    /**
    Parameters checkboxes
    lang is based on html lang declaration, first entry is the default when html lang is unknow
    **/

    FormFieldsetContent: {
      classSetting: 'content',
    },
    FormFieldset: {
      classSetting: 'fieldset',
    },
    LegendFieldset: {
      classSetting: 'legend',
    },
    FormRadio: {
      classSetting: 'radio',
    },

    /** Contrast
    value : className of the dedicated className style
    Important ! : value and id must be identical
    **/

    ContrastFieldset: {
      //caution : don't change
      id: 'contrast',
    },
    ContrastLegend: {
      lang: {
        en: 'Contrast',
        fr: 'Contrastes',
      },
    },
    DefaultContrastCheckbox: {
      id: 'default-contrast',
      value: 'default-contrast',
      //caution : don't change
      groupName: 'contrast',
      //label
      lang: {
        en: 'Default',
        fr: 'Défaut',
      },
    },
    HighContrastCheckbox: {
      id: 'high-contrast',
      value: 'high-contrast',
      //caution : don't change
      groupName: 'contrast',
      //label
      lang: {
        en: 'Reinforce',
        fr: 'Renforcer',
      },
    },
    InvertContrastCheckbox: {
      id: 'inv-contrast',
      value: 'inv-contrast',
      //caution : don't change
      groupName: 'contrast',
      //label
      lang: {
        en: 'Reverse',
        fr: 'Inverser',
      },
    },

    /**
    Dyslexia font
    **/

    DyslexiaFieldset: {
      //caution : don't change
      id: 'font',
    },
    DyslexiaLegend: {
      //label
      lang: {
        en: 'Font (dyslexia)',
        fr: 'Police (dyslexie)',
      },
    },
    DefaultFontCheckbox: {
      id: 'default-font',
      value: 'default-font',
      //caution : don't change
      groupName: 'font',
      //label
      lang: {
        en: 'Default',
        fr: 'Défaut',
      },
    },
    DyslexiaFontCheckbox: {
      id: 'dys-font',
      value: 'dys-font',
      //caution : don't change
      groupName: 'font',
      //label
      lang: {
        en: 'Adapt',
        fr: 'Adapter',
      },
    },

    /**
    Line spacing
    **/

    LineSpacingFieldset: {
      //caution : don't change
      id: 'line-spacing',
    },
    LineSpacingLegend: {
      //label
      lang: {
        en: 'Line spacing',
        fr: 'Interlignage',
      },
    },
    DefaultLineSpacingCheckbox: {
      id: 'default-spacing',
      value: 'default-spacing',
      //caution : don't change
      groupName: 'line-spacing',
      //label
      lang: {
        en: 'Default',
        fr: 'Défaut',
      },
    },
    DyslexiaLineSpacingCheckbox: {
      id: 'dys-spacing',
      value: 'dys-spacing',
      //caution : don't change
      groupName: 'line-spacing',
      //label
      lang: {
        en: 'Increase',
        fr: 'Augmenter',
      },
    },

    /**
    Justification
    **/

    JustificationFieldset: {
      //caution : don't change
      id: 'justification',
    },
    JustificationLegend: {
      //label
      lang: {
        en: 'Justification',
        fr: 'Justification',
      },
    },
    DefaultJustificationCheckbox: {
      id: 'default-justification',
      value: 'default-justification',
      //caution : don't change
      groupName: 'justification',
      //label
      lang: {
        en: 'Default',
        fr: 'Défaut',
      },
    },
    DyslexiaJustificationCheckbox: {
      id: 'cancel-justification',
      value: 'cancel-justification',
      //caution : don't change
      groupName: 'justification',
      //label
      lang: {
        en: 'Remove',
        fr: 'Supprimer',
      },
    },

    /**
    Image replacement
    **/

    ImageReplacementFieldset: {
      //caution : don't change
      id: 'image',
    },
    ImageReplacementCSS: {
      //Css class to use on each image to replace
      replacementCss: 'replace-img',
      //Css class to style the replacement text
      replacementStyle: 'replace-style',
    },
    ImageReplacementLegend: {
      //label
      lang: {
        en: 'Images',
        fr: 'Images',
      },
    },
    DefaultImageReplacementCheckbox: {
      id: 'default-img',
      value: 'default-img',
      //caution : don't change
      groupName: 'image',
      //label
      lang: {
        en: 'Default',
        fr: 'Défaut',
      },
    },
    ImageReplacementCheckbox: {
      id: 'text-img',
      value: 'text-img',
      //caution : don't change
      groupName: 'image',
      //label
      lang: {
        en: 'Replace with text',
        fr: 'Remplacer par du texte',
      },
    },
  };
  //global
  const global = {
    mode: null,
    cookieName: null,
    openObj: null,
    imgTab: null,
    imgSpan: null,
  };
  let userPrefix;

  /** Onload */
  window.onload = () => {
    if (!document.querySelector('[data-accessconfig-params]')) {
      console.log('AccessConfig warning : HTML missing');
      return;
    }
    /** Get parameters define in HTML code by user via data-accessconfig-params attribut (JSON format) **/
    const openButton = document.querySelector('[data-accessconfig-params]');
    global.userParams = JSON.parse(openButton.getAttribute('data-accessconfig-params'));
    userPrefix = global.userParams.Prefix ?? 'a42-ac';

    /** Set the setting form **/
    settingForm();

    /** Modal option**/
    if (global.userParams.Modal === true || global.userParams.Modal === undefined) {
      /** If user set data-accessconfig-param.Modal to true, then create a button to launch the modal **/
      const modalButton = document.createElement('button');
      modalButton.setAttribute('id', `${userPrefix}-${config.ModalButton.id}`);
      modalButton.setAttribute('data-accessconfig-button', 'true');

      if (
        document.querySelector('[data-accessconfig-buttonname]') &&
        !document.querySelector('[id="accessconfig-buttonname-extension"]')
      ) {
        const modalButtonText = document.querySelector('[data-accessconfig-buttonname]');
        const modalButtonTextName = document.createTextNode(modalButtonText.getAttribute('data-accessconfig-buttonname'));
        const modalButtonTextSpan = document.createElement('span');
        modalButtonTextSpan.appendChild(modalButtonTextName);
        modalButton.appendChild(modalButtonTextSpan);
      } else if (
        document.querySelector('[id="accessconfig-buttonname-extension"]') &&
        document.querySelector('[id="accessconfig-buttonname-extension"]').innerHTML !== ''
      ) {
        modalButton.appendChild(document.querySelector('[id="accessconfig-buttonname-extension"]'));
      }

      if (
        document.querySelector('[data-accessconfig-buttontitle]') &&
        document.querySelector('[data-accessconfig-buttontitle]').getAttribute('data-accessconfig-buttontitle') !== ''
      ) {
        modalButton.setAttribute(
          'title',
          document.querySelector('[data-accessconfig-buttontitle]').getAttribute('data-accessconfig-buttontitle'),
        );
      }

      const setup = document.getElementById(config.Setup.id);
      setup.appendChild(modalButton);

      /** Detect other button that can launch the modal by search to data-accessconfig-button="true" **/
      const otherOpenButton = document.querySelectorAll('[data-accessconfig-button="true"]');
      for (let i = 0, len = otherOpenButton.length; i < len; i++) {
        otherOpenButton[i].addEventListener(
          'click',
          function () {
            dialog(this);
          },
          false,
        );
      }
    }

    // Contrast features
    if (global.userParams.Contrast !== false) {
      global.mode = `${userPrefix}-${config.ContrastFieldset.id}`;
      global.cookieName = 'contrast';
      setEvent();
    }
    // Font feature
    if (global.userParams.Font !== false) {
      global.mode = `${userPrefix}-${config.DyslexiaFieldset.id}`;
      global.cookieName = 'font';
      setEvent();
    }
    // Line spacing feature
    if (global.userParams.LineSpacing !== false) {
      global.mode = `${userPrefix}-${config.LineSpacingFieldset.id}`;
      global.cookieName = 'line-spacing';
      setEvent();
    }
    // Justification feature
    if (global.userParams.Justification !== false) {
      global.mode = `${userPrefix}-${config.JustificationFieldset.id}`;
      global.cookieName = 'justification';
      setEvent();
    }
    // Image replacement feature
    if (global.userParams.ImageReplacement !== false) {
      global.mode = `${userPrefix}-${config.ImageReplacementFieldset.id}`;
      global.cookieName = 'image';
      setImgtab();
      setEvent();
    }
  };

  /** Dependencies **/
  /* Create modal or inline setting form : data-accessconfig-params = "Modal" */
  function settingForm() {
    //Constructor
    function $create(o) {
      const tn = o.tagName;
      const x = document.createElement(tn);
      for (const i in o) if (i !== 'tagName' && typeof o[i] !== 'function') x.setAttribute(i, o[i]);
      return x;
    }

    const langRef = setdefaultLang();
    const div = $create({ tagName: 'div', id: userPrefix, class: userPrefix });

    const fieldsetContent = $create({ tagName: 'div', class: `${userPrefix}-${config.FormFieldsetContent.classSetting}` });

    // set modale
    if (global.userParams.Modal === true || global.userParams.Modal === undefined) {
      //modale
      div.setAttribute('role', 'dialog');
      div.setAttribute('aria-labelledby', `${userPrefix}-${config.ModalContainer.titleId}`);
      div.setAttribute('tabindex', '-1');
      if (global.userParams.ContainerClass) {
        div.classList.add(`${userPrefix}-${global.userParams.ContainerClass}`);
      } else {
        div.classList.add(`${userPrefix}-${config.ModalContainer.classSetting}`);
      }
      //title
      const titleWindow = $create({ tagName: 'h1', id: `${userPrefix}-${config.ModalContainer.titleId}` });
      if (global.userParams.ModalTitle) {
        titleWindow.classList.add(userPrefix + global.userParams.ModalTitle);
      } else {
        titleWindow.classList.add(`${userPrefix}-${config.ModalContainer.titleClass}`);
      }
      const titleTxt = document.createTextNode(config.ModalContainer.titleLang[langRef]);
      titleWindow.appendChild(titleTxt);
      div.appendChild(titleWindow);
      //Close button
      const CClose = $create({ tagName: 'button', type: 'button', id: `${userPrefix}-${config.CloseButton.id}` });
      if (global.userParams.ModalCloseButton) {
        CClose.classList.add(userPrefix + global.userParams.ModalCloseButton);
      } else {
        CClose.classList.add(`${userPrefix}-${config.CloseButton.classSetting}`);
      }
      const SpanHidden = $create({ tagName: 'span', class: config.CloseButton.hiddenTextClass });
      const CloseTxt = document.createTextNode(config.CloseButton.lang[langRef]);
      SpanHidden.appendChild(CloseTxt);
      CClose.appendChild(SpanHidden);
      div.appendChild(CClose);
    } else {
      //Inline form
      const setupdiv = document.getElementById(config.Setup.id);
      setupdiv.appendChild(div);
      div.classList.add(`${userPrefix}accessconfig-inline`);
    }

    div.appendChild(fieldsetContent);

    // Settings interface creation helper
    const makeOption = (options) => {
      const fieldset = $create({ tagName: 'fieldset', id: `${userPrefix}-${options.fieldset_id}` });
      const legend = document.createElement('legend');
      legend.appendChild(document.createTextNode(options.legend_text));
      fieldset.appendChild(legend);
      let index = 0;
      for (const checkbox of options.checkboxes) {
        if (checkbox[0]) {
          // Add radio button
          const attributes = {
            tagName: 'input',
            type: 'radio',
            id: `${userPrefix}-${checkbox[1].id}`,
            value: `${userPrefix}-${checkbox[1].value}`,
            name: `${userPrefix}-${checkbox[1].groupName}`,
          };
          if (index === 0) {
            attributes.checked = 'checked';
          }
          fieldset.appendChild($create(attributes));
          // Add radio label
          const CLabel = $create({ tagName: 'label', for: `${userPrefix}-${checkbox[1].id}` });
          CLabel.appendChild(document.createTextNode(checkbox[1].lang[langRef]));
          fieldset.appendChild(CLabel);
          index++;
        }
      }
      fieldsetContent.appendChild(fieldset);
    };

    // Contrast features

    if (global.userParams.Contrast !== false) {
      makeOption({
        fieldset_id: config.ContrastFieldset.id,
        legend_text: config.ContrastLegend.lang[langRef],
        checkboxes: [
          [true, config.DefaultContrastCheckbox],
          [config.Setting.useExtendContrast, config.HighContrastCheckbox],
          [true, config.InvertContrastCheckbox],
        ],
      });
    }

    // Font feature

    if (global.userParams.Font !== false) {
      makeOption({
        fieldset_id: config.DyslexiaFieldset.id,
        legend_text: config.DyslexiaLegend.lang[langRef],
        checkboxes: [
          [true, config.DefaultFontCheckbox],
          [true, config.DyslexiaFontCheckbox],
        ],
      });
    }

    // Line spacing feature

    if (global.userParams.LineSpacing !== false) {
      makeOption({
        fieldset_id: config.LineSpacingFieldset.id,
        legend_text: config.LineSpacingLegend.lang[langRef],
        checkboxes: [
          [true, config.DefaultLineSpacingCheckbox],
          [true, config.DyslexiaLineSpacingCheckbox],
        ],
      });
    }

    // Justification feature

    if (global.userParams.Justification !== false) {
      makeOption({
        fieldset_id: config.JustificationFieldset.id,
        legend_text: config.JustificationLegend.lang[langRef],
        checkboxes: [
          [true, config.DefaultJustificationCheckbox],
          [true, config.DyslexiaJustificationCheckbox],
        ],
      });
    }

    // Image replacement feature

    if (global.userParams.ImageReplacement !== false) {
      makeOption({
        fieldset_id: config.ImageReplacementFieldset.id,
        legend_text: config.ImageReplacementLegend.lang[langRef],
        checkboxes: [
          [true, config.DefaultImageReplacementCheckbox],
          [true, config.ImageReplacementCheckbox],
        ],
      });
    }

    /**Set generic class attributes on fieldset, legend and radio**/

    const allFieldset = div.querySelectorAll('fieldset');
    for (let i = 0, len = allFieldset.length; i < len; i++) {
      if (global.userParams.FormFieldset) {
        allFieldset[i].classList.add(userPrefix + global.userParams.FormFieldset);
      } else {
        allFieldset[i].classList.add(`${userPrefix}-${config.FormFieldset.classSetting}`);
      }
    }

    const allLegend = div.querySelectorAll('legend');
    for (let i = 0, len = allLegend.length; i < len; i++) {
      if (global.userParams.FormFieldsetLegend) {
        allLegend[i].classList.add(userPrefix + global.userParams.FormFieldsetLegend);
      } else {
        allLegend[i].classList.add(`${userPrefix}-${config.LegendFieldset.classSetting}`);
      }
    }

    const allRadio = div.querySelectorAll('input[type="radio"]');
    for (let i = 0, len = allRadio.length; i < len; i++) {
      if (global.userParams.FormRadio) {
        allRadio[i].classList.add(userPrefix + global.userParams.FormRadio);
      } else {
        allRadio[i].classList.add(`${userPrefix}-${config.FormRadio.classSetting}`);
      }
    }

    /** Set the modal **/
    const modalAttach = document.querySelector('body');
    const modalAttachFirstChild = modalAttach.firstChild;
    /** attach modal as the first child of body **/
    if (global.userParams.Modal === true || global.userParams.Modal === undefined)
      modalAttach.insertBefore(div, modalAttachFirstChild);
  }

  /** Get default language (based on lang attribute) **/
  function setdefaultLang() {
    const lang = document.querySelector('html').getAttribute('lang');
    if (lang !== null) {
      const ndx = lang.indexOf('-') > 0 ? lang.indexOf('-') : 3;
      return lang.substring(0, ndx);
    } else {
      return 'en';
    }
  }

  /** Setting managers **/
  function setEvent() {
    const body = document.querySelector('body');
    const fieldset = document.getElementById(global.mode);
    const checkBoxList = fieldset.querySelectorAll('input');
    for (let i = 0, len = checkBoxList.length; i < len; i++) {
      checkBoxList[i].addEventListener(
        'click',
        function () {
          setAdaptive(this);
        },
        false,
      );
    }
    const target = readCookie(global.cookieName);
    if (target) {
      body.classList.add(target);
      for (let i = 0, len = checkBoxList.length; i < len; i++) {
        checkBoxList[i].removeAttribute('checked');
      }
      document.getElementById(target).setAttribute('checked', 'checked');
    }
    //Setting image replacement
    if (body.classList.contains(`${userPrefix}-${config.DefaultImageReplacementCheckbox.value}`)) {
      replaceImgSpan();
    }
    if (body.classList.contains(`${userPrefix}-${config.ImageReplacementCheckbox.value}`)) {
      replaceImg();
    }
  }
  /**Set adaptive mode**/
  function setAdaptive(obj) {
    global.mode = obj.getAttribute('name');
    global.cookieName = obj.getAttribute('name');
    const fieldset = document.getElementById(global.mode);

    const checkBoxList = fieldset.querySelectorAll('input');
    const body = document.querySelector('body');
    for (let i = 0, lenx = checkBoxList.length; i < lenx; i++) {
      const value = checkBoxList[i].getAttribute('value');
      checkBoxList[i].removeAttribute('checked');
      if (value === `${userPrefix}-${config.DefaultImageReplacementCheckbox.value}`) {
        replaceImgSpan();
      }
      body.classList.remove(value);
    }
    const newClass = obj.getAttribute('value');
    obj.setAttribute('checked', 'checked');
    const value = obj.getAttribute('value');
    if (value === `${userPrefix}-${config.ImageReplacementCheckbox.value}`) {
      replaceImg();
    }
    body.classList.add(newClass);
    createCookie(global.cookieName, newClass, '180');
  }

  /**
  Image replacement helpers
  **/

  function setImgtab() {
    global.imgSpan = new Array();
    const selector = `.${userPrefix}-${config.ImageReplacementCSS.replacementCss}`;
    global.imgTab = Array.from(document.querySelectorAll(selector));
    for (let j = 0, len = global.imgTab.length; j < len; j++) {
      const imgPReplacement = document.createElement('span');
      const imgAlt = global.imgTab[j].getAttribute('alt');
      const imgTxtReplacement = document.createTextNode(imgAlt);
      imgPReplacement.appendChild(imgTxtReplacement);
      imgPReplacement.classList.add(`${userPrefix}-${config.ImageReplacementCSS.replacementCss}`);
      imgPReplacement.classList.add(`${userPrefix}-${config.ImageReplacementCSS.replacementStyle}`);
      global.imgSpan[j] = imgPReplacement;
    }
  }
  function replaceImg() {
    for (let j = 0, len = global.imgTab.length; j < len; j++) {
      if (global.imgTab[j].parentNode) {
        const parent = global.imgTab[j].parentNode;
        global.imgTab[j] = parent.replaceChild(global.imgSpan[j], global.imgTab[j]);
      }
    }
  }
  function replaceImgSpan() {
    for (let j = 0, len = global.imgSpan.length; j < len; j++) {
      if (global.imgSpan[j].parentNode) {
        const parent = global.imgSpan[j].parentNode;
        global.imgSpan[j] = parent.replaceChild(global.imgTab[j], global.imgSpan[j]);
      }
    }
  }

  /**
  Modal manager
  **/

  function dialog(returnTo) {
    //on ajoute une classe au body
    document.body.classList.add(`${userPrefix}-${config.BodyActive.classSetting}`);
    const overlay = document.createElement('div');
    overlay.classList.add(`${userPrefix}-${config.Overlay.classSetting}`);
    document.body.appendChild(overlay);

    //open
    global.openObj = document.getElementById(userPrefix);
    global.openObj.style.display = 'block';
    document.getElementById(`${userPrefix}-${config.CloseButton.id}`).focus();
    //Init events
    //escape close
    document.addEventListener('keydown', escClose, false);
    //button close
    const closeButton = document.getElementById(`${userPrefix}-${config.CloseButton.id}`);
    closeButton.addEventListener('click', buttonClose, false);
    //trappingFocus
    document.addEventListener('focus', trappingFocus, true);
    //close functions
    function escClose(event) {
      if (event.keyCode !== 27) {
        return;
      }
      global.openObj.style.display = 'none';
      returnTo.focus();
      //reset listener and object trapping focus
      document.removeEventListener('keydown', escClose, false);
      //on retire la  classe du body
      document.body.classList.remove(`${userPrefix}-${config.BodyActive.classSetting}`);
      const overlay = document.querySelector(`.${userPrefix}-${config.Overlay.classSetting}`);
      if (overlay) {
        overlay.remove();
      }
    }
    function buttonClose() {
      global.openObj.style.display = 'none';
      returnTo.focus();
      //reset listener and object trapping focus
      closeButton.removeEventListener('click', buttonClose, false);
      //on retire la  classe du body
      document.body.classList.remove(`${userPrefix}-${config.BodyActive.classSetting}`);
      const overlay = document.querySelector(`.${userPrefix}-${config.Overlay.classSetting}`);
      if (overlay) {
        overlay.remove();
      }
      //reset object trapping focus
      //global.openObj = null
    }
  }
  /* Generic trapping focus function (based on global.openObj setting) */
  function trappingFocus(event) {
    if (global.openObj && !global.openObj.contains(event.target)) {
      event.stopPropagation();
      global.openObj.focus();
    }
  }

  /**
    Cookies
  **/
  function createCookie(name, value, days) {
    let expires = '';
    if (days) {
      const datetime = new Date();
      datetime.setTime(datetime.getTime() + days * 24 * 60 * 60 * 1000);
      expires = `; expires=${datetime.toGMTString()}`;
    } else expires = '';
    document.cookie = `${name}=${value}${expires}; path=/`;
  }
  function readCookie(name) {
    const nameEQ = `${userPrefix}-${name}=`;
    const ca = document.cookie.split(';');
    for (let c of ca) {
      while (c.charAt(0) === ' ') c = c.substring(1, c.length);
      if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
    }
    return null;
  }
})();
